<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#if sys.getAllPSWorkflows()?? && srflist(sys.getAllPSWorkflows())?size gt 0>
package ${pub.getPKGCodeName()}.util.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONObject;

import ${pub.getPKGCodeName()}.util.domain.*;

/**
 * 统一工作流服务
 */
public interface UniWFFeignClient {

    /* ---------- 业务系统注册内容 ---------- */

    /**
     * 注册统一工作流（域注册）
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/workflows/regist")
    public Workflow registDomain(@RequestBody Workflow workflow);

    /**
     * 注册工作流引擎
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfengines/regist")
    public List<WFEngine> registWFEngine(@RequestBody List<WFEngine> wfengines);

    /**
     * 注册业务系统（部署系统）
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pssystems/regist")
    public PSSystem registPSSystem(@RequestBody PSSystem pssystem);

    /**
     * 注册工作流角色
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfroles/regist")
    public List<PSWFRole> registPSWFRole(@RequestBody List<PSWFRole> pswfroles);

    /**
     * 注册业务工作流
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/psworkflows/regist")
    public List<PSWorkflow> registPSWorkflow(@RequestBody List<PSWorkflow> psworkflows);

    /**
     * 注册业务实体工作流
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/psdewfs/regist")
    public List<PSDEWF> registPSDEWF(@RequestBody List<PSDEWF> psdewfs);

    /**
     * 注册业务实体
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/psdataentities/regist")
    public List<PSDataEntity> registPSDataEntity(@RequestBody List<PSDataEntity> psdataentities);

    /**
     * 注册业务工作流模式
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfmodes/regist")
    public List<WFMode> registWFMode(@RequestBody List<WFMode> wfmodes);

    /* ---------- 工作流应用注册内容 ---------- */

    /**
     * 注册业务应用
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pssysapps/regist")
    public PSSysApp registPSSysApp(@RequestBody PSSysApp pssysapp);

    /**
     * 注册工作流应用
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfapps/regist")
    public WFApp registWFApp(@RequestBody WFApp wfapp);

    /**
     * 注册业务工作流版本
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfversions/regist")
    public List<PSWFVersion> registPSWFVersion(@RequestBody List<PSWFVersion> pswfversions);

    /**
     * 注册流程处理
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfprocesses/regist")
    public List<PSWFProcess> registPSWFProcess(@RequestBody List<PSWFProcess> pswfprocesses);

    /**
     * 注册流程连接
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswflinks/regist")
    public List<PSWFLink> registPSWFLink(@RequestBody List<PSWFLink> pswfprocroles);

    /**
     * 注册流程处理角色
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfprocroles/regist")
    public List<PSWFProcRole> registPSWFProcRole(@RequestBody List<PSWFProcRole> pswfprocroles);

    /**
     * 注册嵌套流程
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfprocsubwfs/regist")
    public List<PSWFProcSubWF> registPSWFProcSubWF(@RequestBody List<PSWFProcSubWF> pswfprocsubwfs);

    /* ---------- 工作流应用驱动 ---------- */

    /**
     * 创建工作流实例
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfinstances/")
    public WFInstance createWFInstance(@RequestBody WFInstance wfinstance);

    /**
     * 测试当前用户是否提交过工作流
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfworklists/{wfworklist_id}/testuserwfsubmit/")
    public boolean testUserWFSubmit(@PathVariable("wfworklist_id") String wfworklist_id, @RequestBody JSONObject data);

    /**
     * 流程标记已读
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfworklists/{wfworklist_id}/wfmarkread/")
    public boolean wfMarkRead(@PathVariable("wfworklist_id") String wfworklist_id, @RequestBody JSONObject data);

    /**
     * 权限检查
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/checkPermisson/")
    public boolean checkPermission();

    /* ---------- 获取数据 ---------- */
    /**
     * 获取业务工作流版本
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/pswfversions/{pswfversion_id}")
    public PSWFVersion getPSWFVersion(@PathVariable("pswfversion_id") String pswfversion_id);

    /**
     * 获取工作列表
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfworklists/{wfworklist_id}")
    public WFWorkList getWFWorkList(@PathVariable("wfworklist_id") String wfworklist_id);

    /**
     * 获取工作列表（查询条件）
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfworklists/fetchdefault")
    public Page<WFWorkList> getWFWorkListByCondition(JSONObject condition);

    /**
     * 获取工作实例（查询条件）
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfinstances/fetchdefault")
    public Page<WFInstance> getWFInstanceByCondition(JSONObject condition);

    /**
     * 获取业务实体工作流（查询条件）
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/psdewfs/fetchdefault")
    public Page<PSDEWF> getPSDEWFByCondition(JSONObject condition);

    /**
     * 获取流程实例
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfinstances/{wfinstance_id}")
    public WFInstance getWFInstance(@PathVariable("wfinstance_id") String wfinstance_id);

    /**
     * 获取代理数据
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfinstances/proxydata/{bswfid}")
    public String wfGetProxyData(@PathVariable("bswfid") String bswfid);

    /* ---------- 清除数据 ---------- */
    /**
     * 清除嵌套流程
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfprocsubwfs/clearbyproc")
    public JSONObject clearPSWFProcSubWF(@RequestBody JSONObject data);

    /**
     * 清除流程处理角色
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfprocroles/clearbyproc")
    public JSONObject clearPSWFProcRole(@RequestBody JSONObject data);

    /* ---------- 流程统一平台接口驱动 ---------- */
    /**
     * 流程启动
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfversions/{pswfversion_id}/wfstart")
    public JSONObject apiWfStart(@PathVariable("pswfversion_id") String pswfversion_id, @RequestBody JSONObject data);
}
</#if>
